<?php
// ====== CONFIG ======
$data_file = __DIR__ . "/ab_status.json";

// Autoriser uniquement ces origines (ajoute/retire si besoin)
$allowed_origins = [
  "https://tf-stb.xdock.de",
  "https://tf-stb-kl.xdock.de",
  "https://tf-stb-tk.xdock.de",
  "https://tf-stb-kt.xdock.de",
  "https://tf-stb-tl.xdock.de",
];

// ====== CORS ======
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
if (in_array($origin, $allowed_origins, true)) {
  header("Access-Control-Allow-Origin: $origin");
  header("Vary: Origin"); // pour caches
}
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Max-Age: 86400"); // 24h

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(204);
  exit;
}

// ====== INIT FICHIER ======
if (!file_exists($data_file)) {
  file_put_contents($data_file, json_encode(new stdClass(), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// ====== LECTURE ======
$data = json_decode(file_get_contents($data_file), true);
if (!is_array($data)) $data = [];

// ====== ROUTAGE ======
header("Content-Type: application/json; charset=utf-8");

switch ($_SERVER['REQUEST_METHOD']) {
  case 'GET':
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    break;

  case 'POST':
    $body = json_decode(file_get_contents("php://input"), true);
    if (!isset($body['tournee']) || !array_key_exists('ab', $body)) {
      http_response_code(400);
      echo json_encode(["error" => "Champs manquants (tournee, ab)"]);
      break;
    }
    $tournee = (string)$body['tournee'];
    $ab = (bool)$body['ab'];
    $data[$tournee] = $ab;
    file_put_contents($data_file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    echo json_encode(["success" => true, "tournee" => $tournee, "ab" => $ab]);
    break;

  default:
    http_response_code(405);
    echo json_encode(["error" => "Méthode non autorisée"]);
}
